#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"
SAVE_PATH="exps/forgetting_avg_case/syn_img"
LIRA_PATH="exps/forgetting_avg_case/lira"

python src/coreset/run_cifar.py \
    --dataset cifar10 \
    --data_path $DATA_PATH \
    --data_augmentation \
    --output_dir $SAVE_PATH \
    --lira_path $LIRA_PATH \
    --seed 1 \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --num_canaries 500 \
    --avg_case > logs/coreset/forgetting_avg_case_$exp_id.log 2>&1

python src/coreset/order_examples_by_forgetting.py \
    --output_dir $SAVE_PATH \
    --output_name cifar10_sorted \
    --input_dir $SAVE_PATH \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --input_fname_args \
        dataset cifar10 \
        data_augmentation True \
        cutout False 